
/*
This driver is modified from drv94421A.c in Linux kernel 2.6.23
*/

#include <linux/version.h>
#include <linux/kernel.h>   /* printk() */
#include <linux/module.h>
#include <linux/pci.h>
#include <linux/string.h>
#include <linux/fs.h>       /* everything... */
#include <linux/errno.h>    /* error codes */
#include <linux/init.h>
#include <linux/sched.h>      /* interrupt */
#include <linux/interrupt.h>  /* interrupt for request_irq(), free_irq() */
#include <linux/moduleparam.h>
#include <asm/io.h>  //inb,outb ...
#include <asm/uaccess.h>
#include <linux/cdev.h>       /* struct cdev */
#include <linux/kdev_t.h>     /* MKDEV(int major, int minor) */
#include <linux/workqueue.h>
#include <linux/delay.h>

#include "drv94421A.h"

//#define UCLINUX
// #define DEBUG

MODULE_DESCRIPTION ( "EX94421A" );	
MODULE_AUTHOR ( "EX94421A" );
// MODULE_LICENSE ( "Proprietary" );
MODULE_LICENSE("GPL");

int count = 1;				//c_dev register and unregister use
int EX94421A_count = 0;		//open device count
int EX94421A_found = 0;		//find cards number
int EX94421A_major = EXDRV_MAJOR;	//device major number
int EX94421A_minor = EXDRV_MINOR;	//device minor number


card_resource CardInfo[16];
struct cdev *c_dev;
struct pci_dev *EX94421A_dev[16];
struct fasync_struct *EX94421A_fasync_queue;

pci_info PciInfo[]=
{
  {
    .vendor_id =	0x1573,		//Lattices
    .device_id =		0x0100,
    .subvendor_id = 	0x6936,
    .subdevice_id = 	0x3310,
    .address_offset0 = 0,		//base_address offset
    .address_offset1 = 1,		//tc_address offset
  },
  {0,},
};
/*thread pameter*/
int CardID=0;
int				temp_address;
int 				time_used_flag=0,time_views=0;
unsigned short			i,j,k,Accuracy;
long				AD_range,changeData;		
long				AD_DATA[1000][24];	//place where the sum ad data.
long long				AD_SUM_DATA[24];		//place where the ad data.
unsigned long			AD_FULL;
/*work queue*/
// struct workqueue_struct *queue = NULL;
static struct work_struct works;
MODULE_AUTHOR("Shakespeare");
static void int_thread(void* data)
{


	changeData=0;
//***********************AD read******************
        for (i=0;i<8;i++)
	{
		//clear AD_SUM_DATA
		if(time_views==0 && time_used_flag==0)
		{
			AD_SUM_DATA[i]=0;
		}
		//delete data 0~7
		if( AD_SUM_DATA[i] != 0 && time_used_flag==1)
		{
			//pdev->AD_SUM_DATA[i]-=pdev->AD_DATA[pdev->time_views][i];	
			changeData=AD_DATA[time_views][i];
		}
		else
		{
			changeData=0;
		}
		//read chennel.0~7
		temp_address=(unsigned long)(CardInfo[CardID].tc_address)+(LATTICE_AD00_DATA+i*2);
		//pdev->AD_DATA[pdev->time_views][i]=READ_PORT_USHORT((PUSHORT)(temp));	
		AD_DATA[time_views][i]=inw ( temp_address );
		//KdPrint(("temp = %x , data = %d , channel = %d",LATTICE_AD00_DATA+i*2,pdev->AD_DATA[pdev->time_views][i],i));

		//comparison ad_range in where.
		//0:+-5    1:+-10
		temp_address=(unsigned long)(CardInfo[CardID].tc_address)+(LATTICE_AD00_CONFIG+i*2);
		AD_range=inw(temp_address);	
                AD_range=(AD_range ) & 0xf;
                //printk ( KERN_WARNING "port = %d  AD_range = %d \n",i,AD_range);
		if((AD_range ==LATTICE_5V_5V || AD_range ==LATTICE_10V_10V ) && (AD_DATA[time_views][i] > (long)(AD_FULL/2-1)))
		{
                         AD_DATA[time_views][i]-=AD_FULL;
		}
		//save data 0~7
		AD_SUM_DATA[i]= AD_SUM_DATA[i] + AD_DATA[time_views][i]-changeData;	
		//count channel
               // printk(KERN_WARNING "AD_SUM_DATA[%d] = %ld \n",i,AD_SUM_DATA[i] );
                //msleep(1);
	}  
	//KdPrint(("%d     %d \n", pdev->AD_SUM_DATA[5],pdev->AD_DATA[pdev->time_views][5]));
	time_views=time_views+1;
	//reset time_views
	if (time_views>=Accuracy) 
	{
		time_views=0;
		time_used_flag=1;
	}
//	printk(KERN_WARNING "CardInfo[CardID].thread_flag = %d \n",CardInfo[CardID].thread_flag);
//	printk(KERN_WARNING "time_views = %d \n",time_views);
	if(CardInfo[CardID].thread_flag==1)	
	{
                //printk ( KERN_WARNING "thread reopen \n");
                msleep(2);
		schedule_work(&works);
	}
}

//****************Devices Interrupt ISR process********************//
#if LINUX_VERSION_CODE > KERNEL_VERSION(2,6,19)
static irqreturn_t EX94421A_interrupt(int irq, void *dev_id)
#else
static irqreturn_t EX94421A_interrupt(int irq, void *dev_id, struct pt_regs *regs)
#endif
{
	card_resource *temp = dev_id;

#ifdef DEBUG
	printk ( "#EX94421A :(ISR) check CardID = %lx \n",temp->CardID );
#endif
	
	//read card data
	CardInfo[temp->CardID].pci_enable = inb(CardInfo[temp->CardID].base_address + LATTICE_PCI_IRQ_ENABLE);	
	CardInfo[temp->CardID].irq_status = (inb(CardInfo[temp->CardID].base_address + LATTICE_TTL_IRQ_STATUS) & 0xff);
	CardInfo[temp->CardID].irq_mask = (inb(CardInfo[temp->CardID].base_address + LATTICE_TTL_IRQ_MASK) & 0xff);

	CardInfo[temp->CardID].irq_tcstatus[0] = (inw(CardInfo[temp->CardID].tc_address + LATTICE_TC0_IRQ_STATUS) & 0x01);
	CardInfo[temp->CardID].irq_tcmask[0] = (inw(CardInfo[temp->CardID].tc_address + LATTICE_TC0_IRQ_MASK) & 0x01);
	CardInfo[temp->CardID].irq_tcstatus[1] = (inw(CardInfo[temp->CardID].tc_address + LATTICE_TC1_IRQ_STATUS) & 0x01);
	CardInfo[temp->CardID].irq_tcmask[1] = (inw(CardInfo[temp->CardID].tc_address + LATTICE_TC1_IRQ_MASK) & 0x01);
	
	if (CardInfo[temp->CardID].pci_enable && ((CardInfo[temp->CardID].irq_status && CardInfo[temp->CardID].irq_mask) || (CardInfo[temp->CardID].irq_tcstatus[0] && CardInfo[temp->CardID].irq_tcmask[0]) || (CardInfo[temp->CardID].irq_tcstatus[1] && CardInfo[temp->CardID].irq_tcmask[1])))
	{
		CardInfo[temp->CardID].irq_flag = 1;//set flag
		
		outb(CardInfo[temp->CardID].irq_status, CardInfo[temp->CardID].base_address + LATTICE_TTL_IRQ_STATUS);	//reset irq status
		outw(CardInfo[temp->CardID].irq_tcstatus[0], CardInfo[temp->CardID].tc_address + LATTICE_TC0_IRQ_STATUS);//reset tc0 irq status
		outw(CardInfo[temp->CardID].irq_tcstatus[1], CardInfo[temp->CardID].tc_address + LATTICE_TC1_IRQ_STATUS);//reset tc1 irq status
		
		if(EX94421A_fasync_queue)
			kill_fasync(&EX94421A_fasync_queue, SIGIO, POLL_IN);	//send SIGIO to dll function "EX94421A_sigaction"
  	
		return IRQ_HANDLED;
	}
	
	return IRQ_NONE;
}

static int EX94421A_fasync ( int fd, struct file *filp, int mode )
{
	return fasync_helper(fd, filp, mode, &EX94421A_fasync_queue);
}


//*************ioctal*******************//
static int EX94421A_ioctl(struct inode *inode, struct file *filp, unsigned int cmd, unsigned long arg)
{
	card_resource *pdev = (card_resource* ) arg;
	unsigned char temp_irq_data, result;
	
	switch(cmd)
	{	
//----------------------------------------------------------------------			
		case EXPCI_WORK_QUEUE_ENABLE:
			CardID=pdev->CardID;
			CardInfo[CardID].AD_Mode=pdev->AD_Mode;
			printk ( KERN_WARNING "pdev->AD_Mode = %d \n",pdev->AD_Mode );
			if(pdev->AD_Mode==11 )
			{
				//*******************event****************
				CardInfo[pdev->CardID].thread_flag = 0;
				//***************************************
                                //*******************clear Ad Sum Data****
                                for( i = 0 ; i < 24 ; i++)
                                {
                                    AD_SUM_DATA[i] = 0;
                                }
			}
			else if(pdev->AD_Mode != 11)
			{
				
				if(pdev->AD_Mode==0)	
				{
					Accuracy=1;
				}
				else
				{
                                        Accuracy=CardInfo[CardID].AD_Mode*RESOLUTION;
				}	
				AD_FULL=65536;				//16bit
				time_used_flag=0;
				time_views=0;
				
				/***************************open thread************************************/
		
				CardInfo[pdev->CardID].thread_flag = 1;
				CardID=pdev->CardID;	
				schedule_work(&works);
				//************************************************************************************
			}
			return SUCCESS;
//----------------------------------------------------------------------	
//----------------------------------------------------------------------			
		case EXPCI_AD_DATA_READ:	
			for(i=0;i<24;i++)
			{
				if(CardInfo[CardID].AD_Mode==0) 
				{
						if(AD_DATA[0][i]<0)	
						{
							pdev->ad_data[i]=AD_DATA[0][i]+AD_FULL;
						}
						else
						{
							pdev->ad_data[i]=AD_DATA[0][i];
						}
				}
				else
				{
						if(AD_SUM_DATA[i]<0)	
						{
							pdev->ad_data[i]=AD_SUM_DATA[i]+(AD_FULL*CardInfo[CardID].AD_Mode*RESOLUTION);
						}
						else
						{
							pdev->ad_data[i]=AD_SUM_DATA[i];
						}
				}
                                                //printk(KERN_WARNING "Read AD_SUM_DATA[0] = %ld \n",AD_SUM_DATA[0] );
                                                //printk(KERN_WARNING "Read pdev->ad_data[0]= %ld \n",pdev->ad_data[0] );
			}	
			return SUCCESS;
//----------------------------------------------------------------------	
		case EXPCI_FIND:						
			pdev->iodata.b[0] = find_EX94421A();
			printk(KERN_WARNING "#EX94421A: Find cards:%d\n",EX94421A_found);				
			return SUCCESS;
//----------------------------------------------------------------------
		case EXPCI_RESOURCE:	
			if(CardInfo[pdev->iodata.b[0]].CardID != NO_CARD)
			{
				pdev->CardID = CardInfo[pdev->iodata.b[0]].CardID;
				pdev->base_address = CardInfo[pdev->iodata.b[0]].base_address;
				pdev->tc_address = CardInfo[pdev->iodata.b[0]].tc_address;
						
				#ifdef DEBUG
					printk(KERN_WARNING "base_address = %lx\n",pdev->base_address);
					printk(KERN_WARNING "tc_address = %lx\n",pdev->tc_address);
				#endif
				if(pci_enable_device(EX94421A_dev[pdev->iodata.b[0]]) == SUCCESS)
				{
					printk(KERN_WARNING "#EX94421A: Devices Enable SUCCESS\n");
					return SUCCESS;
				}
				else
					return INITIAL_FAIL;
			}
			else
				return NOPCIDEV;
//----------------------------------------------------------------------					
		case EXPCI_RBYTE:
			if(pdev->base_address != 0)
			{				
				pdev->iodata.b[0] = inb(pdev->base_address + pdev->address_offset);				
#ifdef DEBUG
                                printk(KERN_WARNING "EXPCI_RBYTE\n");
                                printk(KERN_WARNING "pdev->iodata.b[0] %d\n",pdev->iodata.b[0]);
#endif
				return SUCCESS;
			}		
			else
			{
				printk(KERN_WARNING "base_address error\n");
				return INVALID_ADDRESS;
			}
//----------------------------------------------------------------------
		case EXPCI_WBYTE:
			if(pdev->base_address != 0)
			{
#ifdef DEBUG
                            printk(KERN_WARNING "EXPCI_WBYTE\n");
                            printk(KERN_WARNING "pdev->iodata.b[0] %d\n",pdev->iodata.b[0]);
#endif
				outb(pdev->iodata.b[0], pdev->base_address + pdev->address_offset);
                                return SUCCESS;
			}		
			else
			{
				printk(KERN_WARNING "base_address error\n");
				return INVALID_ADDRESS;
			}
//----------------------------------------------------------------------
		case EXPCI_RWORD:
			if ( pdev->base_address!=0 )
			{
#ifdef DEBUG
#endif
                            printk(KERN_WARNING "RWORD\n");
				pdev->iodata.w[0]=inw ( ( pdev->tc_address ) + ( pdev->address_offset ) );
				return SUCCESS;
			}
			else			
				return -INVALID_ADDRESS;
//----------------------------------------------------------------------
		case EXPCI_WWORD:
			if ( pdev->base_address!=0 )
			{
				printk(KERN_WARNING "WORD\n");
				outw ( pdev->iodata.w[0], ( pdev->tc_address ) + ( pdev->address_offset ) );
				return SUCCESS;
			}
			else
				return -INVALID_ADDRESS;
//----------------------------------------------------------------------			
		case EXPCI_HOOK_IRQ_SR:
			if (EX94421A_dev[pdev->CardID]	!=	NULL )
			{						
#if LINUX_VERSION_CODE > KERNEL_VERSION(2,6,19)
				result = request_irq(
							EX94421A_dev[pdev->CardID]->irq,
							EX94421A_interrupt,
							IRQF_SHARED,
							"EX94421A",
							&CardInfo[pdev->CardID]);	//request irq fc8
#else
				result = request_irq(	
							EX94421A_dev[pdev->CardID]->irq, 
							EX94421A_interrupt, 
							SA_SHIRQ, 
							"EX94421A", 
							&CardInfo[pdev->CardID]);	//request irq fc4
#endif
					if (result)
					{
						printk ( KERN_WARNING "#EX94421A : result = %i\n",result );
						printk ( KERN_WARNING "#EX94421A : can't get assigned irq \n" );
					}
				
					else
					{
#ifdef DEBUG
						printk ( KERN_WARNING "#EX94421A : get assigned irq = %i\n",EX94421A_dev[pdev->CardID]->irq );
#endif
						outb(	inb(CardInfo[pdev->CardID].base_address + LATTICE_TTL_IRQ_STATUS)	,
							CardInfo[pdev->CardID].base_address + LATTICE_TTL_IRQ_STATUS);	//reset irq Lattice

						outw(	inw(CardInfo[pdev->CardID].tc_address + LATTICE_TC0_IRQ_STATUS), 	
							CardInfo[pdev->CardID].tc_address + LATTICE_TC0_IRQ_STATUS);	//reset tc0 irq Lattice

						outw(	inw(CardInfo[pdev->CardID].tc_address + LATTICE_TC1_IRQ_STATUS), 
							CardInfo[pdev->CardID].tc_address + LATTICE_TC1_IRQ_STATUS);	//reset tc1 irq Lattice
						return SUCCESS;
					}						
			}
			return -ENODEV;
//----------------------------------------------------------------------
		case EXPCI_UNHOOK_IRQ_SR:
			if (EX94421A_dev[pdev->CardID] != NULL )
			{
#ifdef DEBUG
				printk ( KERN_WARNING "#EX94421A : base_address = %lx\n",CardInfo[pdev->CardID].base_address );
				printk ( KERN_WARNING "#EX94421A : tc_address = %lx\n",CardInfo[pdev->CardID].tc_address );
				printk ( KERN_WARNING "#EX94421A : free irq %x \n",EX94421A_dev[pdev->CardID]->irq );
#endif
				free_irq(EX94421A_dev[pdev->CardID]->irq, &CardInfo[pdev->CardID]); //delete irq register

				return SUCCESS;
			}
			return -ENODEV;
//----------------------------------------------------------------------			
		case EXPCI_IRQ_FLAG:	
			pdev->irq_flag = CardInfo[pdev->CardID].irq_flag;
#ifdef DEBUG
			printk ( KERN_WARNING "#EX94421A : pdev->CardID =%lx \n",pdev->CardID );
			printk ( KERN_WARNING "#EX94421A : pdev->irq_flag =%x \n",pdev->irq_flag );
#endif
			return SUCCESS;
//----------------------------------------------------------------------			
		case EXPCI_IRQ_CLEARFLAG:
			CardInfo[pdev->CardID].irq_flag = 0;
			return SUCCESS;
//----------------------------------------------------------------------			
		case EXPCI_IRQ_STATUS_READ:
// 			switch(pdev->source)
// 			{
// 				case 0:
// 					temp_irq_data = inb(CardInfo[pdev->CardID].base_address + LATTICE_TTL_IRQ_STATUS);
// 					outb(temp_irq_data, CardInfo[pdev->CardID].base_address + LATTICE_TTL_IRQ_STATUS);
// 					pdev->irq_status = temp_irq_data | CardInfo[pdev->CardID].irq_status;
// 					CardInfo[pdev->CardID].irq_status = 0;
// 					break;
// 				case 1:
// 					temp_irq_data = inw(CardInfo[pdev->CardID].tc_address + LATTICE_TC0_IRQ_STATUS);
// 					outw(temp_irq_data, CardInfo[pdev->CardID].tc_address + LATTICE_TC0_IRQ_STATUS);
// 					pdev->irq_tcstatus[0] = temp_irq_data | CardInfo[pdev->CardID].irq_tcstatus[0];
// 					CardInfo[pdev->CardID].irq_tcstatus[0] = 0;
// 					break;
// 			}

			temp_irq_data = inb(CardInfo[pdev->CardID].base_address + LATTICE_TTL_IRQ_STATUS);	//read io status
			outb(temp_irq_data, CardInfo[pdev->CardID].base_address + LATTICE_TTL_IRQ_STATUS);	//reset io status
			pdev->irq_status = temp_irq_data | CardInfo[pdev->CardID].irq_status;
                        CardInfo[pdev->CardID].irq_status = 0;

			temp_irq_data = inw(CardInfo[pdev->CardID].tc_address + LATTICE_TC0_IRQ_STATUS);
			outw(temp_irq_data, CardInfo[pdev->CardID].tc_address + LATTICE_TC0_IRQ_STATUS);
			pdev->irq_tcstatus[0] = temp_irq_data | CardInfo[pdev->CardID].irq_tcstatus[0];
			CardInfo[pdev->CardID].irq_tcstatus[0] = 0;

			temp_irq_data = inw(CardInfo[pdev->CardID].tc_address + LATTICE_TC1_IRQ_STATUS);
			outw(temp_irq_data, CardInfo[pdev->CardID].tc_address + LATTICE_TC1_IRQ_STATUS);
			pdev->irq_tcstatus[1] = temp_irq_data | CardInfo[pdev->CardID].irq_tcstatus[1];
			CardInfo[pdev->CardID].irq_tcstatus[1] = 0;

			return SUCCESS;
//----------------------------------------------------------------------	
		default:
			return INVALID_CMD;
	}
}


//************find card****************//
static int find_EX94421A(void)
{
	struct pci_dev *temp_dev = NULL;
	unsigned short count;	
#ifdef I386
	unsigned long CardID;
	unsigned long temp_base_address;
	unsigned long temp_tc_address;
#else
	unsigned int CardID;
	unsigned int temp_base_address;
	unsigned int temp_tc_address;
#endif
#ifdef UCLINUX
	int temp_base_address_ioremap;
	int temp_tc_address_ioremap;
#endif
	
	//Initialize data
	EX94421A_found = 0;
	for(count=0; count<EX_MAXDEV; count++)
	{
		EX94421A_dev[count] = NULL;
		CardInfo[count].CardID = NO_CARD;
		CardInfo[count].irq_flag = 0;
		CardInfo[count].thread_flag=0;
	}

	for(EX94421A_found=0; EX94421A_found<EX_MAXDEV;)		
	{		
		//get pci device
		temp_dev = pci_get_subsys(	PciInfo[0].vendor_id, PciInfo[0].device_id, PciInfo[0].subvendor_id, PciInfo[0].subdevice_id, temp_dev);
		//temp_dev = pci_get_device(	PciInfo[0].vendor_id, PciInfo[0].device_id, temp_dev);
		if(!temp_dev)
		{
			#ifdef DEBUG
				printk ( KERN_WARNING "break 49 \n");			
			#endif
			break;
		}		
		else
		{	
/*------------------ test --------------------------		
#ifdef DEBUG
              printk(KERN_WARNING"#EX3206 : subvendor=%x \n", temp_dev->subsystem_vendor);
              printk(KERN_WARNING"#EX3206 : subsystem=%x \n", temp_dev->subsystem_device);
#endif
			break;
*///-----------------------------------------------------
			temp_base_address	= pci_resource_start(temp_dev, PciInfo[0].address_offset0);	//get pci base_address
			temp_tc_address	= pci_resource_start(temp_dev, PciInfo[0].address_offset1);	//get pci tc_address

#ifdef UCLINUX
			//remap virtual address to physical address
			temp_base_address_ioremap	= ( int ) ioremap ( temp_base_address,0x100 );
			temp_tc_address_ioremap	= ( int ) ioremap ( temp_tc_address,0x100 );
			
			CardID= inb (temp_base_address_ioremap + LATTICE_CARD_ID );
			CardInfo[CardID].base_address=temp_base_address_ioremap;
			CardInfo[CardID].tc_address=temp_tc_address_ioremap;
#else
			CardID = inb(temp_base_address + LATTICE_CARD_ID);			
			CardInfo[CardID].base_address = temp_base_address;
			CardInfo[CardID].tc_address = temp_tc_address;
#endif
			CardInfo[CardID].CardID = CardID;		
			EX94421A_dev[CardID] = temp_dev; //get pci device
			EX94421A_found++;
#ifdef DEBUG
			printk(KERN_WARNING "#EX94421A: CardID:%ld\n",CardInfo[CardID].CardID);
			printk(KERN_WARNING "#EX94421A: base_address:%lx\n",CardInfo[CardID].base_address);
			printk(KERN_WARNING "#EX94421A: tc_address:%lx\n",CardInfo[CardID].tc_address);
			printk(KERN_WARNING "#EX94421A: EX94421A_found:%d\n",EX94421A_found);				
#endif
		}
	}
	return EX94421A_found;
}


//******************************//
static int EX94421A_open(struct inode *inode, struct file *filp)
{
	EX94421A_count++;
#ifdef DEBUG
	printk(KERN_WARNING "#EX94421A: EX94421A count:%d\n", EX94421A_count);
#endif
	return SUCCESS;
}

static int EX94421A_release(struct inode *inode, struct file *filp)
{
	EX94421A_count--;
	EX94421A_fasync(-1, filp, 0);		//clear fasync data
#ifdef DEBUG
	printk(KERN_WARNING "#EX94421A: EX94421A count:%d\n", EX94421A_count);
#endif
	return SUCCESS;
}



//***************************//
static int __init EX94421A_init(void)
{
	int status;
	dev_t devno;
	
#ifdef DEBUG
	printk(KERN_WARNING "--------EX94421A_init--------\n");
#endif
	EX94421A_found = find_EX94421A();		//check find cards number
	
	if(EX94421A_found > 0)
	{
		status = alloc_chrdev_region(&devno, 0, count, "EX94421A"); //register device number
		EX94421A_major = MAJOR(devno);	//get device MAJOR number
		
		if(status < 0)
			printk(KERN_WARNING "#EX94421A: alloc_chrdev_region status:%d\n", status);

		//register char device driver
		c_dev = cdev_alloc();
		c_dev->owner = THIS_MODULE;
		c_dev->ops = &ex_fops;
		status = cdev_add(c_dev, devno, count);
		
		if(status < 0)
			printk(KERN_WARNING "#EX94421A: cdev_add status:%d\n", status);
		
#ifdef DEBUG	
		printk(KERN_WARNING "#EX94421A: MAJOR:%d\n", EX94421A_major);
#endif	
		/*work queue creat*/		    
//          	queue = create_singlethread_workqueue("helloworld"); /*?建一?單線??工作???/
//         	destroy_workqueue(queue);

		/*creat works*/
		INIT_WORK(&works, (void*)int_thread);
 		//works->data=(void )c_dev;
		//queue_work(queue,works);
		/**/
		return SUCCESS;
	}
	
	else	
		return INITIAL_FAIL;
}

static void EX94421A_exit(void)
{
	//unregister char device driver
	dev_t devno = MKDEV(EX94421A_major, EX94421A_minor);
	cdev_del(c_dev);
	unregister_chrdev_region(devno, count);
	/*queue finish*/
#ifdef DEBUG
	printk(KERN_WARNING "#EX94421A: GoodBye\n");
#endif
}

module_init(EX94421A_init);
module_exit(EX94421A_exit);

